<!DOCTYPE html>
<html>
	<head>
		<meta charset="utf-8">

		<link rel="stylesheet" type="text/css" href="<?php echo Yii::app()->baseUrl; ?>/css/screen.css" media="screen, projection" />
		<link rel="stylesheet" type="text/css" href="<?php echo Yii::app()->baseUrl; ?>/css/print.css" media="print" />

		<link rel="stylesheet" type="text/css" href="<?php echo Yii::app()->baseUrl.'/css/main.css?'.filemtime('css/main.css'); ?>" />
		<link rel="stylesheet" type="text/css" href="<?php echo Yii::app()->baseUrl.'/css/game.css?'.filemtime('css/game.css'); ?>" />
		<link rel="stylesheet" type="text/css" href="<?php echo Yii::app()->baseUrl.'/css/form.css?'.filemtime('css/form.css'); ?>" />
		<link rel="stylesheet" type="text/css" href="<?php echo Yii::app()->getModule('student')->getAssetsUrl(); ?>/css/ingameForm.css?<?php echo filemtime(Yii::app()->getModule('student')->getAssetsUrl(false).'/css/ingameForm.css'); ?>" />

		<link rel="shortcut icon" href="<?php echo Yii::app()->baseUrl; ?>/images/favicon.ico" />

		<?php Yii::app()->clientScript->registerCoreScript('jquery'); ?>

		<?php if(isset($this->module) && !empty($this->module->id)): ?>
			<?php Yii::app()->clientScript->registerScriptFile(Yii::app()->baseUrl.'/src/js/moodle.js?'.filemtime('src/js/moodle.js'), CClientScript::POS_HEAD); ?>
			<link rel="stylesheet" type="text/css" href="<?php echo Yii::app()->baseUrl; ?>/css/admin.css"/>
		<?php endif; ?>

		<title><?php echo CHtml::encode($this->pageTitle); ?></title>
	</head>

	<body>
		<div id="bodywrapper">
			<div class="container" id="page">
				<div id="headerbar">
					<img src="<?php echo Yii::app()->baseUrl; ?>/images/gui/logo.png" alt="Kreatywnie w przedsiębiorczość" />
				</div>

				<div id="mainmenu">
					<?php
					// przycinanie nazwy użytkownika
					$login=Yii::app()->user->name;
					if(strlen($login)>7)
					{
						$login=substr($login,0,7);
						$login.="..";
					}

					$this->widget('zii.widgets.CMenu',array(
						'items'=>array(
							array('label'=>'Gra', 'url'=>array('/site/index')),
							array('label'=>'Platforma edukacyjna', 'url'=>'http://kreatywnie.lublin.eu/elearning/', 'linkOptions' => array('target'=>'_blank')),
							array('label'=>'Panel nauczyciela', 'url'=>array( Yii::app()->user->isTeacher ? '/teacher/main/index' : '/administration/main/index' ),
									'visible'=>($this->module !== null && ($this->module->id == 'teacher'|| $this->module->id == 'administration') &&
											(!Yii::app()->user->isTeacher && !Yii::app()->user->isAdministrator && !Yii::app()->user->isSchoolAdministrator)
										   ) || ( ($this->module == null || $this->module->id=='student') && !Yii::app()->user->isStudent),
									'active'=>$this->module !== null && ($this->module->id == 'teacher'|| $this->module->id == 'administration') ),
							array('linkOptions'=>array('id'=>'logoutButton'), 'label'=>'Wyloguj ('.$login.')', 'url'=>array('/teacher/main/logout'), 'visible'=>Yii::app()->user->isTeacher && $this->module!==null),
							array('linkOptions'=>array('id'=>'logoutButton'), 'label'=>'Wyloguj ('.$login.')', 'url'=>array('/administration/main/logout'), 'visible'=>(Yii::app()->user->isAdministrator || Yii::app()->user->isSchoolAdministrator) && $this->module!==null),
							array('linkOptions'=>array('id'=>'logoutButton'), 'label'=>'Wyloguj ('.$login.')', 'url'=>array('/student/main/logout'), 'itemOptions'=>array('class'=>'hiddenMenu')),
						),
					)); ?>
				</div>

				<?php if(isset($this->breadcrumbs)):?>
					<?php $this->widget('zii.widgets.CBreadcrumbs', array(
						'links'=>$this->breadcrumbs,
					)); ?>
				<?php endif?>
			<div style="overflow:hidden; clear: both;height:100%">

				<div class="container" style="height:100%">
					<div id="content" style="height:100%">
						<?php echo $content; ?>
					</div>
				</div>

				<div id="footer">
					<a href="http://www.efs.gov.pl/" target="_blank"><img src="<?php echo Yii::app()->baseUrl; ?>/images/footer/logo-pokl.png" class="footerImg footerLogo-left" alt="POKL" /></a>
					<a href="http://www.pollub.pl/" target="_blank"><img src="<?php echo Yii::app()->baseUrl; ?>/images/footer/logo5.png" class="footerImg footerLogo-center" alt="Politechnika Lubelska" /></a>
					<a href="http://inkubator.pollub.pl/" target="_blank"><img src="<?php echo Yii::app()->baseUrl; ?>/images/footer/logo4.png" class="footerImg footerLogo-center" alt="Lubelski Inkubator Przedsiębiorczości Politechniki Lubelskiej" /></a>
					<a href="http://www.um.lublin.pl/" target="_blank"><img src="<?php echo Yii::app()->baseUrl; ?>/images/footer/logo3.png" class="footerImg footerLogo-center" alt="Lublin inspiruje biznes" /></a>
					<a href="http://www.um.lublin.pl/" target="_blank"><img src="<?php echo Yii::app()->baseUrl; ?>/images/footer/logo1.png" class="footerImg footerLogo-center" alt="Herb Lublina" /></a>
					<a href="http://www.efs.gov.pl/" target="_blank"><img src="<?php echo Yii::app()->baseUrl; ?>/images/footer/logo-ue.png" class="footerImg footerLogo-right" alt="UE" /></a>
					<div id="footer-txt">Projekt współfinansowany ze środków Unii Europejskiej w ramach Europejskiego Funduszu Społecznego.</div>
				</div>

			</div>
		</div>
		</div>
	</body>
</html>
